//@input Component.ScreenTransform parentScreenTransform
//@input Component.Text displayNameText
//@input Component.Text additionalText
//@input Component.Image bitmojiImage
//@input SceneObject firstPlaceMedal
//@input SceneObject parent
//@input int displayNameLength = 15

const displayNameUtils = require("./DisplayNameUtils");
const MAX_DISPLAY_NAME_LENGTH = script.displayNameLength;
script.getParentScreenTransform = getParentScreenTransform;
script.setUserRecord = setUserRecord;
script.setBitmoji = setBitmoji;

function setUserRecord(userRecord) {
    if (isNull(userRecord)) {
        return;
    }

    let dataIsSet = false;
    let nameIsSet = false;

    if (!isNull(userRecord.snapchatUser) && !isNull(userRecord.snapchatUser.displayName)) {
        script.displayNameText.text = displayNameUtils.formatDisplayName(userRecord.snapchatUser.displayName, MAX_DISPLAY_NAME_LENGTH);
        nameIsSet = true;
    }

    if (!isNull(userRecord.snapchatUser) && !isNull(userRecord.globalRankPercentile) && userRecord.globalRankPercentile !== 0) {
        script.additionalText.text = "Top " + userRecord.globalRankPercentile + "% worldwide";
        dataIsSet = true;
    }

    if (!isNull(userRecord.snapchatUser) && !isNull(userRecord.snapchatUser.globalExactRank) && userRecord.globalExactRank !== 0) {
        script.firstPlaceMedal.enbaled = true;
        dataIsSet = true;
    }

    if (dataIsSet && nameIsSet) {
        setEnabled(true);
    }
}

function getParentScreenTransform() {
    return script.parentScreenTransform;
}

function setBitmoji(bitmoji) {
    if (script.bitmojiImage && bitmoji) {
        script.bitmojiImage.mainMaterial.mainPass.bitmojiTex = bitmoji;
    }
}

function setEnabled(enabled) {
    script.parent.enabled = enabled;
}

setEnabled(false);
